<?php 
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    $campiAggiuntiviRicerca = array("tipoRicerca"=>"buoniSsonto","status"=>101);
    if(isset($_GET["cerca"]) && $_GET["tipoRicerca"]=="buoniSsonto") {
        $cercaBuoniSconto = $_GET["cerca"];
        $parametriRicerca = array("nome"=>filter_input(INPUT_GET,"cerca",FILTER_SANITIZE_ADD_SLASHES));
    }
    else {
        $cercaBuoniSconto = "";
        $parametriRicerca = array();
    }

    $parametri = array("tabella"=>"geecEc_buoniSconto", "elementiPerPagina"=>$elementiPerPagina,"parametriRicerca"=>$parametriRicerca,"ajax"=>false);
      
    $ricerca = new Ricerca($geecomDb, $parametri, $impostazioniRicerca,"index.php");
?>
    <h4 class="mb-4 title">Buoni sconto</h4>
    <a href="creaBuonoSconto.php" class="btn btn-sm btn-primary" >
	Crea buono<i class="fas fa-plus ml-2"></i>
    </a>
    <hr>

    <div class="d-flex justify-content-between mb-3">
        <?php
            $ricerca->stampaSelectNumeroElementi($cercaBuoniSconto,$campiAggiuntiviRicerca);
            $ricerca->stampaFormRicerca($cercaBuoniSconto,$campiAggiuntiviRicerca);
        ?>
    </div>
    <div class="table-responsive table-sm">
        <?php

            if(isset($_GET["pag"])) {
                $ris = $ricerca->eseguiRicerca($_GET["pag"],"OR");
            }
            else {
                $ris = $ricerca->eseguiRicerca(1,"OR");
            }
            
            $colonne = array("ID","Nome","Codice","Buoni rimanenti","Data creazione","");
            $tabella = new Tabella("tabella", "table table-striped table-hover",$colonne);
            $tabella->setTipo("normale");
            while($buono = $ris->fetch_assoc()) {
                $nomeEscape    = filter_var($buono["nome"],FILTER_SANITIZE_ADD_SLASHES);
                $dataCreazione = date("d/m/Y",strtotime($buono["dataCreazione"]));
                $azioni = array("modifica"=>"creaBuonoSconto.php?id={$buono["id"]}","elimina"=>"apriPopupEliminaBuonoSconto({$buono["id"]},'$nomeEscape')");
                
                $tabella->aggiungiNuovaRiga(array($buono["id"],"<a href=\"creaBuonoSconto.php?id={$buono["id"]}\"><b>".$buono["nome"]."</b></a>",$buono["codice"],$buono["buoniRimanenti"],$dataCreazione),$azioni);
            }
            $tabella->stampa("rigaBuonoSconto",0);
            $ricerca->stampaPaginazione(true,"index.php");
        ?>
    </div>